import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_merchant/data/services/api_service.dart';

import '../../../../../core/utils/dimensions.dart';
import '../../../../../core/utils/my_strings.dart';
import '../../../../../data/controller/invoice/create_invoice_controller.dart';
import '../../../../components/bottom-sheet/bottom_sheet_header_row.dart';
import '../../../../components/buttons/rounded_button.dart';
import '../../../../components/buttons/rounded_loading_button.dart';
import '../../../../components/divider/custom_divider.dart';
import '../../../../components/row_widget/bottom_sheet_row.dart';

class CreateInvoicePreviewBottomSheet extends StatelessWidget {
  const CreateInvoicePreviewBottomSheet({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<CreateInvoiceController>(
      builder: (controller) => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const BottomSheetHeaderRow(header: MyStrings.invoicePreview),
          const SizedBox(height: Dimensions.space15),
          BottomSheetRow(
            header: MyStrings.totalAmount,
            body: "${Get.find<ApiClient>().getCurrencyOrUsername(isSymbol: true)}${controller.totalInvoiceAmount}",
          ),
          const SizedBox(height: Dimensions.space10),
          BottomSheetRow(
            header: MyStrings.totalCharge,
            body: "${Get.find<ApiClient>().getCurrencyOrUsername(isSymbol: true)}${controller.charge}",
          ),
          const CustomDivider(space: 15),
          BottomSheetRow(
            header: MyStrings.willGet,
            body: "${Get.find<ApiClient>().getCurrencyOrUsername(isSymbol: true)}${controller.getableText}",
          ),
          const SizedBox(height: Dimensions.space30),
          controller.isSubmitLoading
              ? const RoundedLoadingBtn()
              : RoundedButton(
                  text: MyStrings.confirm,
                  press: () {
                    controller.submitInvoice();
                  })
        ],
      ),
    );
  }
}
